<?php
session_start(); // Memulai sesi

// Mengecek apakah pengguna sudah login
if (!isset($_SESSION['id'])) {
    // Jika belum login, alihkan ke halaman login
    header("Location: index.php"); // Ganti 'login.php' dengan nama file halaman login Anda
    exit();
}

// Jika sudah login, ambil ID pengguna
$id_login = $_SESSION['id'];
// Anda bisa menggunakan $id_login untuk mengambil data pengguna dari database jika diperlukan
?>
<div class=site-content-container data-container-background=general style="--image-src:url('../bundles/img/bg/slots.jpg')">

    <div class=container>

        <div class=row>

            <div class=col-md-12>

                <div class="row standard-main-container">

                    <div class="standard-side-menu">

                        <div class="player-account-section">

                            <div class="username"><?php echo $punya_user['username']; ?></div>

                            <div class="last-login-date">Jam Sekarang : <?php echo date('l, d-m-Y  H:i:s'); ?></div>

                        </div>

                        <div class="menu-section">

                            <div class="title">Pusat Akun</div>

                            <hr>

                            <a href="?page=profile" data-active="false"> 

                                <i data-icon="profile" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/profile-active.svg?v=20231212-1)"></i> 

                                <span> Akun Saya </span> 

                            </a> 

                            <a href="?page=deposit" data-active="true"> 

                                <i data-icon="bank" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/bank-account-active.svg?v=20231212-1)"></i> 

                                <span> Bank </span> 

                            </a> 

                            <a href="?page=refferal" data-active="false"> 

                                <i data-icon="referral" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/referral-active.svg?v=20231212-1)"></i> 

                                <span> Referensi </span> 

                            </a> 

                        </div>

                    </div>

                    <div class=standard-main-content>  

                        <ul class="bank-status-list">

                        <?php

                        $query = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin' ");

                        while ($data = mysqli_fetch_array($query)) {

                            ?>



                                <li data-online="true" data-ztip-title="" data-tooltip="Senin - Jumat online 00:00-00:00 WIB Sabtu online 00:00-00:00 WIB Minggu online 00:00-00:00 WIB">

                                    <img src="../uploads/bank/<?php echo $data['icon'] ?>">

                                </li>

                            

                            <?php

                        }

                        ?> 

                        </ul>

                        <div class=top-tab-container>

                            <a data-active=true href="?page=deposit">

                                <i data-icon=deposit style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-active.svg?v=20231212-1)"></i>

                                Deposit 

                            </a>

                            <a data-active=false href="?page=withdraw">

                                <i data-icon=withdrawal style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal-active.svg?v=20231212-1)"></i>

                                Penarikan 

                            </a>

                            <a data-active=false href="?page=history">

                                <i data-icon=history style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-history.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-history-active.svg?v=20231212-1)"></i>

                                Transaksi Saya 

                            </a>

                        </div>

                        <div class=tab-content-container> 

                            <div class=standard-form-title>DEPOSIT</div>

                            <div class="standard-form-content deposit-container">

                                <div class="standard-form-note deposit-note">

                                    <div class=deposit-note-icon>

                                        <img loading=lazy src="//nx-cdn.trgwl.com/Images/wallet/deposit.svg?v=20231212-1">

                                    </div>

                                    <div class=deposit-note-content>

                                        <span>Catatan:</span>

                                        <ul>

                                            <li>Perhatikan Nomor Rekening Tujuan</li>

                                            <li>Nominal Transfer Harus Sesuai Dengan Nominal Yang Anda Input</li>

                                            <li>Harap Gunakan Kode Unik 333 Untuk Proses Deposit</li>

                                        </ul>

                                    </div>

                                </div>

                                <form action="?page=proses_deposit" enctype="multipart/form-data" id=deposit_form method=post name=depositForm>

                                    <div class="form-group deposit-form-group balance-info-container" style="background-color: #efeff3">

                                        <label for=Balance>Saldo</label>

                                        <div data-section=input>

                                            <span class=formatted-balance style="color:#ef0101">(<?php echo number_format($balance); ?>) </span>

                                        </div>

                                    </div>

                                    <div class="form-group deposit-form-group" style="background-color: #efeff3">

                                        <label for=PaymentMethod>

                                            Metode Pembayaran <span data-section=asterisk>*</span>

                                        </label>

                                        <div data-section=input >

                                            <div id=payment_method_selection class=payment-method-selection >

                                                <input type=radio name=PaymentType id=payment_method_BANK value=BANK checked >

                                                <label for=payment_method_BANK>

                                                    <img loading=lazy src="//nx-cdn.trgwl.com/Images/payment-types/BANK.svg?v=20231212-1" >

                                                    <span>Bank / E-Wallet</span>

                                                </label>

                                            </div>

                                            <span class=field-validation-valid data-valmsg-for=PaymentType data-valmsg-replace=true></span>

                                        </div>

                                    </div>

                                    <div class="form-group deposit-form-group" style="background-color: #efeff3">

                                        <label for=Amount >

                                            Jumlah <span data-section=asterisk>*</span>

                                        </label>

                                        <div class=deposit-amount-container data-section=depo-amount >

                                            <div data-section=depo-input>

                                                <div data-field=amount>            

                                                    <input class="form-control deposit_amount_input" required="" name=nominal type=number style="color: black" placeholder="50000">

                                                </div>

                                            </div>

                                        </div>

                                        <label class="formulir-desc">Deposit Minimal <?php echo $min_depo; ?></label>

                                    </div>

                                    <div class=deposit-form-group>

                                        <div class=form-group>

                                            <div class=to-account-label-container>

                                                <label for=ToAccount>

                                                    Akun Tujuan <span data-section=asterisk>*</span>

                                                </label>

                                            </div>

                                            <div data-section=input>

                                                <select name="metode" id=deposit_bank_select class=form-control data-val=true data-val-required="Pilih bank perusahaan untuk disetor">

                                                    <option selected="" disabled=""> -- Pilih Bank -- </option>



                                                    <?php

                                                    $query = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin'");

                                                    while ($data = mysqli_fetch_array($query)) {

                                                        $id_bank = $data['id'];

                                                        $nama_bank = $data['nama_bank'];

                                                        $nomor_rekening = $data['nomor_rekening'];

                                                        $nama_pemilik = $data['nama_pemilik'];

                                                        ?>

                                                        <option value="<?php echo $id_bank; ?>"><?php echo $nama_bank; ?> / <?php echo $nama_pemilik; ?> </option>

                                                        <?php

                                                    }

                                                    ?>

                                                </select>

                                            </div>

                                        </div>

                                        

                                        <div class=form-group>

                                            <div data-section=input data-bank-type=bank class=bank-info id=bank_info>

                                                <?php

                                                $querya = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin'");

                                                while ($dataq = mysqli_fetch_array($querya)) {

                                                    $id_bank = $dataq['id'];

                                                    $nama_bank1 = $dataq['nama_bank'];

                                                    $nomor_rekening = $dataq['nomor_rekening'];

                                                    $nama_pemilik = $dataq['nama_pemilik'];

                                                    $icon = $dataq['icon'];

                                                    ?>

                                                    <div class="bankOption" style="display: none" id="epayment-<?php echo $id_bank; ?>">

                                                        <div id="bank_info_logo"> 

                                                            <img src="../uploads/bank/<?php echo $icon ?>">

                                                        </div>

                                                        <br>

                                                        <h1 id=bank_info_account_name><?php echo $nama_pemilik; ?></h1>

                                                        <br>

                                                        <h2 id=bank_info_account_no><?php echo $nomor_rekening; ?></h2>

                                                    </div>

                                                    <?php

                                                }

                                                ?>

                                                <div data-bank-info=qrcode id=bank_qr_code></div>

                                                <hr>

                                                <div data-bank-info=actions>

                                                    <div class=admin-fee-container>

                                                        Kode Unik :<div id=admin_fee_display class=admin-fee>123</div>

                                                    </div>

                                                    <button class=copy-bank-account-button id=copy_bank_account_button type=button>

                                                        <span class="glyphicon glyphicon-file"></span>

                                                        Salin 

                                                    </button>

                                                </div>

                                            </div>

                                        </div> 

                                    </div>



                                    <div class=deposit-form-group>

                                        <div class=form-group>

                                            <div class=to-account-label-container>

                                                <label for=ToAccount>

                                                    Bonus <span data-section=asterisk>*</span>

                                                </label>



                                            </div>

                                            <div data-section=input>

                                                <select name="bonus" class=form-control required="">

                                                    <option value="tanpabonus" selected="">Tanpa Bonus</option>

                                                    <?php

                                                    $query = mysqli_query($koneksi, "SELECT * FROM tb_bonus WHERE status = 'active'");

                                                    while ($data = mysqli_fetch_array($query)) {

                                                        ?>

                                                        <option value="<?php echo $data['id'] ?>"><?php echo $data['judul']; ?></option>

                                                        <?php

                                                    }

                                                    ?>

                                                </select>

                                            </div>

                                        </div>

                                        

                                        

                                    </div>





                                    <div class="form-group deposit-form-group">

                                        <label for=TransactionReceipt>Tanda Terima Transaksi</label>

                                        <div data-section=input>

                                            <input class=form-control id=TransactionReceipt name="bukti_transfer" type="file">

                                        </div>

                                        <label class="formulir-desc">Hanya format *.jpg, *.jpeg, dan *.png yang diperbolehkan, maksimal 1 MB</label>



                                    </div>

                                    <div class=standard-button-group>

                                        <input type=submit name="submit" class="btn btn-primary" value=DEPOSIT>

                                    </div>

                                </form>      

                            </div>

                        </div>

                    </option>

                </select>

            </div>

        </div>

    </div>

</div>

</div>

</div>



        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

        <script>

            $(document).ready(function() {

    // Ketika elemen <select> berubah

    $("#deposit_bank_select").change(function() {

        // Mendapatkan nilai yang dipilih

        var selectedValue = $(this).val();

        

        // Semua section yang memiliki class "bankOption" disembunyikan

        $(".bankOption").hide();



        // Menampilkan elemen dengan ID yang sesuai berdasarkan pilihan

        if (selectedValue !== "") {

            $("#epayment-" + selectedValue).show();

        }

    });

});

</script>



