<?php
session_start(); // Memulai sesi

// Mengecek apakah pengguna sudah login
if (!isset($_SESSION['id'])) {
    // Jika belum login, alihkan ke halaman login
    header("Location: index.php"); // Ganti 'login.php' dengan nama file halaman login Anda
    exit();
}

// Jika sudah login, ambil ID pengguna
$id_login = $_SESSION['id'];
// Anda bisa menggunakan $id_login untuk mengambil data pengguna dari database jika diperlukan
?>
<div class="site-content-container" data-container-background="general" style="--image-src:url(../bundles/img/bg/slots.jpg)">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

				<div class="row profile-container standard-main-container">

					<div class="standard-side-menu">

						<div class="player-account-section">

							<div class="username"><?php echo $punya_user['username']; ?></div>

							<div class="last-login-date">Jam Sekarang : <?php echo date('l, d-m-Y  H:i:s'); ?></div>

						</div>

						<div class="menu-section">

							<div class="title">Pusat Akun</div>

							<hr>

							<a href="?page=profile" data-active="false"> 

								<i data-icon="profile" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/profile-active.svg?v=20231212-1)"></i> 

								<span> Akun Saya </span> 

							</a> 

							<a href="?page=deposit" data-active="true"> 

								<i data-icon="bank" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/bank-account-active.svg?v=20231212-1)"></i> 

								<span> Bank </span> 

							</a> 

							

							<a href="?page=refferal" data-active="false"> 

								<i data-icon="referral" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/referral-active.svg?v=20231212-1)"></i> 

								<span> Referensi </span> 

							</a> 

						</div>

					</div>

					<div class="standard-main-content">

						<div class=top-tab-container>

							<a data-active=false href="?page=deposit">

								<i data-icon=deposit style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-active.svg?v=20231212-1)"></i>

								Deposit 

							</a>

							<a data-active=false href="?page=withdraw">

								<i data-icon=withdrawal style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal-active.svg?v=20231212-1)"></i>

								Penarikan 

							</a>

							<a data-active=true href="?page=history">

								<i data-icon=history style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-history.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-history-active.svg?v=20231212-1)"></i>

								Transaksi Saya 

							</a>

						</div>

						<div class=tab-content-container>



							<div class=standard-form-title>RIWAYAT TRANSAKSI DEPOSIT & WITHDRAW</div>

							<div class=standard-form-content>



								<table class="table grid_table">

									<thead>

										<tr>

											<th scope=col>No</th>

											<th scope=col>Tipe Pembayaran</th>

											<th scope=col>Jumlah</th>

											<th scope=col>Tanggal/Waktu (GMT+7)</th>

											<th scope=col>

											Status</th>

										</tr>

									</thead>

									<tbody>

										

										<?php 

										$query = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE id_user = '$extplayer' ORDER BY id DESC ");

										$no = 1;

										while ($data = mysqli_fetch_array($query)) {

											?>

											<tr>

												<td><?php echo $no++; ?></td>

												<td><?php echo $data['transaksi'] ?></td>

												<td>Rp. <?php echo number_format($data['total']) ?></td>

												<td><?php echo $data['tanggal'] ?></td>

												<td><?php echo $data['status'] ?></td>

											</tr>

											<?php

										}

										?>

										

									</tbody>

								</table>

							</form>

						</div>

					</div>>

				</div>

			</div>

		</div>

	</div>

</div>

</div>