<?php
session_start(); // Memulai sesi

// Mengecek apakah pengguna sudah login
if (!isset($_SESSION['id'])) {
    // Jika belum login, alihkan ke halaman login
    header("Location: index.php"); // Ganti 'login.php' dengan nama file halaman login Anda
    exit();
}

// Jika sudah login, ambil ID pengguna
$id_login = $_SESSION['id'];
// Anda bisa menggunakan $id_login untuk mengambil data pengguna dari database jika diperlukan
?>
<div class="site-content-container" data-container-background="general" style="--image-src:url(../bundles/img/bg/slots.jpg)">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

				<div class="row profile-container standard-main-container">

					<div class="standard-side-menu">

						<div class="player-account-section">

							<div class="username"><?php echo $punya_user['username']; ?></div>

							<div class="last-login-date">Jam Sekarang : <?php echo date('l, d-m-Y  H:i:s'); ?></div>

						</div>

						<div class="menu-section">

							<div class="title">Pusat Akun</div>

							<hr>

							<a href="?page=profile" data-active="true"> 

								<i data-icon="profile" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/profile-active.svg?v=20231212-1)"></i> 

								<span> Akun Saya </span> 

							</a> 

							<a href="?page=deposit" data-active="false"> 

								<i data-icon="bank" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/bank-account-active.svg?v=20231212-1)"></i> 

								<span> Bank </span> 

							</a> 

							

							<a href="?page=refferal" data-active="false"> 

								<i data-icon="referral" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/referral-active.svg?v=20231212-1)"></i> 

								<span> Referensi </span> 

							</a> 

						</div>

					</div>

					<div class="standard-main-content">

						<div class="top-tab-container">

							<a data-active="true" href="?page=profile"> 

								<i data-icon="profile" style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/profile.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/profile-active.svg?v=20231212-1)"></i> Akun Saya 

							</a> 

							<a data-active="false" href="?page=password"> 

								<i data-icon="password" style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/password.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/password-active.svg?v=20231212-1)"></i> Ubah Kata Sandi 

							</a> 

						</div>

						<div class="tab-content-container">

							<div class="standard-profile-bar">

								<section class="user-field">

									<img loading="lazy" src="//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/loyalty/badge/bronze.svg?v=20231212-1">

									<div>

										<span class="username"><?php echo $punya_user['username']; ?></span>

										<div class="loyalty-info-container">

											<div class="xp-field">

												<span class="xp-label">Level</span> <?php echo $punya_user['level']; ?>

											</div>

											<div class="lp-field">

												<span class="lp-label">Status</span> <?php echo $punya_user['status']; ?>

											</div>

											<div>

												<a href="#">Detail &gt;&gt;</a>

											</div>

										</div>

									</div>

								</section>

								<section class="deposit-field">

									<a href="?page=deposit"> 

										<img loading="lazy" src="//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-active.svg?v=20231212-1"> 

										<span>Deposit</span> 

									</a>

								</section>

								<section class="withdraw-field">

									<a href="?page=withdraw"> 

										<img loading="lazy" src="//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal-active.svg?v=20231212-1"> Penarikan 

									</a>

								</section>

								



							</div>

							<div class="standard-form-title">INFORMASI AKUN</div>

							<div class="standard-content-info" style="border-color: #1a1a1a;">

								<div class="standard-content-block" style="background-color: #1a1a1a;">

									<table class="table profile-summary-table">

										<tbody>

											<tr>

												<th>Nama Lengkap</th>

												<td>:</td>

												<td><?php echo $punya_user['nama_lengkap']; ?></td>

											</tr>

											<tr>

												<th>Email</th>

												<td>:</td>

												<td><?php echo $punya_user['email']; ?></td>

											</tr>

											<tr>

												<th>Nama Pengguna</th>

												<td>:</td>

												<td><?php echo $punya_user['username']; ?></td>

											</tr>

											<tr>

												<th>No Handphone</th>

												<td>:</td>

												<td><?php echo $punya_user['no_hp']; ?></td>

											</tr>

											<tr>

												<th>Mata Uang</th>

												<td>:</td>

												<td>IDR</td>

											</tr>

										</tbody>

									</table>

								</div>

								<div class="standard-content-block" style="background-color: #1a1a1a;">

									<div class="banking-details-header">

										<label>Detail Perbankan</label> 

									</div>

									<div id="bank_account_carousel" class="carousel slide bank-info-container" data-interval="false" data-ride="carousel">

										<ol class="carousel-indicators">

											<li data-target="#bank_account_carousel" data-slide-to="0" class="active"></li>

										</ol>

										<div class="carousel-inner" >

											<div class="bank-info-block item active" style="background-color: #3e3e3e;">

												<div class="account-name"><?php echo $bank_user['nama_pemilik']; ?> 	

											</div>

											<div class="account-number"><?php echo $bank_user['nomor_rekening']; ?></div><hr style="border: 0.3px solid grey">

											<div class="bank-name"><?php echo $bank_user['nama_bank']; ?></div>

										</div>

									</div>

								</div>

							</div>

						</div>







						<div class="standard-form-title">STATUS SETORAN / PENARIKAN</div>

						<div class="standard-content-info"><div>

							<h2>Status Deposit Terakhir</h2>

							<table class="table last-transaction-table">

								<thead>

									<tr>

										<th scope="col">Jumlah</th>

										<th scope="col">Tanggal/Waktu</th>

										<th scope="col" class="text-center">Status</th>

									</tr>

								</thead>

								<tbody>

									<?php

									$query = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE transaksi = 'Withdraw' ORDER BY id DESC LIMIT 5");

									while ($data = mysqli_fetch_array($query)) {

										?>

										<tr>

											<td>Rp. <?php echo number_format($data['total']) ?></td>

											<td><?php echo $data['tanggal'] ?></td>

											<td><?php echo $data['status'] ?></td>

										</tr>

										<?php

									}

									?>

								</tbody>

							</table>

						</div>

						<div>

							<h2>Status Penarikan Terakhir</h2>

							<table class="table last-transaction-table">

								<thead>

									<tr>

										<th scope="col">Jumlah</th>

										<th scope="col">Tanggal/Waktu</th>

										<th scope="col" class="text-center">Status</th>

									</tr>

								</thead>

								<tbody>

									<?php

									$query = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE transaksi = 'Top Up' ORDER BY id DESC LIMIT 5");

									while ($data = mysqli_fetch_array($query)) {

										?>

										<tr>

											<td>Rp. <?php echo number_format($data['total']) ?></td>

											<td><?php echo $data['tanggal'] ?></td>

											<td><?php echo $data['status'] ?></td>

										</tr>

										<?php

									}

									?>

								</tbody>

							</table>

						</div>

					</div>

				</div>

			</div>

		</div>

	</div>

</div>

</div>

</div>