<?php
session_start(); // Memulai sesi

// Mengecek apakah pengguna sudah login
if (!isset($_SESSION['id'])) {
    // Jika belum login, alihkan ke halaman login
    header("Location: index.php"); // Ganti 'login.php' dengan nama file halaman login Anda
    exit();
}

// Jika sudah login, ambil ID pengguna
$id_login = $_SESSION['id'];
// Anda bisa menggunakan $id_login untuk mengambil data pengguna dari database jika diperlukan
?>
<div class=site-content-container data-container-background=general style="--image-src:url(../bundles/img/bg/slots.jpg)">

    <div class=container>

        <div class=row>

            <div class=col-md-12>

                <div class="row standard-main-container">

                    <div class="standard-side-menu">

                        <div class="player-account-section">

                            <div class="username"><?php echo $punya_user['username']; ?></div>

                            <div class="last-login-date">Jam Sekarang : <?php echo date('l, d-m-Y  H:i:s'); ?></div>

                        </div>

                        <div class="menu-section">

                            <div class="title">Pusat Akun</div>

                            <hr>

                            <a href="?page=profile" data-active="false"> 

                                <i data-icon="profile" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/profile-active.svg?v=20231212-1)"></i> 

                                <span> Akun Saya </span> 

                            </a> 

                            <a href="?page=deposit" data-active="true"> 

                                <i data-icon="bank" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/bank-account-active.svg?v=20231212-1)"></i> 

                                <span> Bank </span> 

                            </a>  

                            <a href="?page=refferal" data-active="false"> 

                                <i data-icon="referral" style="background-image:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/referral-active.svg?v=20231212-1)"></i> 

                                <span> Referensi </span> 

                            </a> 

                        </div>

                    </div>

                    <div class=standard-main-content>

                        <ul class="bank-status-list">

                            <?php

                            $query = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin' ");

                            while ($data = mysqli_fetch_array($query)) {

                                ?>



                                <li data-online="true" data-ztip-title="" data-tooltip="Senin - Jumat online 00:00-00:00 WIB Sabtu online 00:00-00:00 WIB Minggu online 00:00-00:00 WIB">

                                    <img src="../uploads/bank/<?php echo $data['icon'] ?>">

                                </li>



                                <?php

                            }

                            ?> 

                        </ul>

                        <div class=top-tab-container>

                            <a data-active=false href="?page=deposit">

                                <i data-icon=deposit style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-active.svg?v=20231212-1)"></i>

                                Deposit 

                            </a>

                            <a data-active=true href="?page=withdraw">

                                <i data-icon=withdrawal style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/withdrawal-active.svg?v=20231212-1)"></i>

                                Penarikan 

                            </a>

                            <a data-active=false href="?page=history">

                                <i data-icon=history style="--image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-history.svg?v=20231212-1);--active-image-src:url(//nx-cdn.trgwl.com/Images/nexus-alpha/red/desktop/tabs/deposit-history-active.svg?v=20231212-1)"></i>

                                Transaksi Saya 

                            </a>

                        </div>

                        <div class=tab-content-container>

                            <div class=standard-form-title>PENARIKAN</div>

                            <div class="standard-form-content withdrawal-container">

                                <div class="standard-form-note withdrawal-note">

                                    <div class=withdrawal-note-icon>

                                        <img loading=lazy src="//nx-cdn.trgwl.com/Images/wallet/withdrawal.svg?v=20231212-1">

                                    </div>

                                    <div class=withdrawal-note-content>

                                        <span>Catatan:</span>

                                        <ul>

                                            <li>Jika ada beberapa perubahan dalam jadwal offline bank ini bukan otoritas kami.

                                                <li>Biaya admin akan diinfokan ketika proses transaksi telah selesai di proses.

                                                </ul>

                                            </div>

                                        </div>

                                        <div class="form-group withdrawal-form-group balance-info-container" style="background-color: #efeff3">

                                            <label for=Balance>Total Saldo</label>

                                            <div data-section=input style="color: #ef0101">

                                                (<?php echo number_format($balance); ?>) 

                                            </div>

                                        </div>

                                        <form action="?page=proses_withdraw" method="POST" id=withdrawal_form method=post name=withdrawalForm>



                                            <div class="form-group withdrawal-form-group" style="background-color: #efeff3">

                                                <label for=UserName>Nama Pengguna</label>

                                                <div data-section=input><?php echo $punya_user['username'] ?></div>

                                            </div>

                                            <div class="form-group withdrawal-form-group" style="background-color: #efeff3">

                                                <label for=PaymentMethod>

                                                    Metode Pembayaran <span data-section=asterisk>*</span>

                                                </label>

                                                <div data-section=input>

                                                    <div id=payment_method_selection class=payment-method-selection>

                                                        <input type=radio name=PaymentType id=payment_method_BANK value=BANK checked>

                                                        <label for=payment_method_BANK>

                                                            <img loading=lazy src="//nx-cdn.trgwl.com/Images/payment-types/BANK.svg?v=20231212-1">

                                                            <span>Bank</span>

                                                        </label>

                                                        <input type=radio name=PaymentType id=payment_method_EMONEY value=EMONEY>

                                                        <label for=payment_method_EMONEY>

                                                            <img loading=lazy src="//nx-cdn.trgwl.com/Images/payment-types/EMONEY.svg?v=20231212-1">

                                                            <span>E-Money</span>

                                                        </label>

                                                    </div>

                                                    <span class=field-validation-valid data-valmsg-for=PaymentType data-valmsg-replace=true></span>

                                                </div>

                                            </div>

                                            <div class="form-group withdrawal-form-group" style="background-color: #efeff3">

                                                <label for=Amount>

                                                    Jumlah Penarikan <span data-section=asterisk>*</span>

                                                </label>

                                                <div data-section=input>

                                                    <input autocomplete=off class="form-control withdrawal_amount_input" data-val=true data-val-required="The Amount field is required." id=Amount name=jumlah type=text>

                                                    <span class=standard-required-message>Silahkan masukan angka untuk jumlah penarikan.</span>

                                                </div>

                                                <div class=real-withdrawal-amount id=real_withdrawal_amount></div>

                                            </div>

                                            <div class="form-group withdrawal-form-group" style="background-color: #efeff3">

                                                <label for=ToAccount>

                                                    Pilih Bank Anda <span data-section=asterisk>*</span>

                                                </label>

                                                <div data-section=input>

                                                    <select name=bank id=withdrawal_bank_select class=form-control data-val=true data-val-required="The PlayerBankAccountNumber field is required.">

                                                        <option value="php|085432321234" data-admin-fee=0><?php echo $bank_user['nama_bank'] ?> | <?php echo $bank_user['nomor_rekening']; ?> 

                                                        </select>

                                                        <span class=field-validation-valid data-valmsg-for=PlayerBankAccountNumber data-valmsg-replace=true></span>

                                                    </div>

                                                </div>

                                                

                                                <div class=standard-button-group>

                                                    <input type=submit name="submit" class="btn btn-primary" value=TARIK>

                                                </div>

                                            </form>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

