<?php

	include '../../function/connect.php';

	

    $query = mysqli_query($koneksi, "SELECT agent_code, signature, base_url_api FROM tb_api LIMIT 1");

    $data = mysqli_fetch_assoc($query) ?: ['agent_code' => null, 'signature' => null, 'base_url_api' => null];

    $agen_code = $data['agent_code'];

    $sign = $data['signature'];

    $base_url = $data['base_url_api'];

	

	class ApimaxAPI {

		private $base_url;

		private $agent_code;

		private $signature;

		

		public function __construct($agent_code, $signature, $base_url) {

			$this->agent_code = $agent_code;

			$this->signature = $signature;

			$this->base_url = $base_url;

		}

		

		private function generate_signature() {

			return $this->signature; // Static signature as provided

		}

		

		private function build_url($endpoint, $params) {

			$params['agent_code'] = $this->agent_code;

			$params['signature'] = $this->generate_signature();

			$url = $this->base_url . $endpoint . '?' . http_build_query($params);

			return $url;

		}

		

		private function send_request($url) {

			$ch = curl_init();

			curl_setopt($ch, CURLOPT_URL, $url);

			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.47 Safari/537.36');

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

			

			$output = curl_exec($ch);

			curl_close($ch);

			return json_decode($output, true);

		}

		

		public function createMember($username) {

			$endpoint = "CreateMember.aspx";

			$params = array('username' => $username);

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function getBalanceUser($username) {

			$endpoint = "GetBalance.aspx";

			$params = array('username' => $username);

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function getAgentInfo() {

			$endpoint = "AgentInfo.ashx";

			$url = $this->build_url($endpoint, array());

			return $this->send_request($url);

		}

		

		public function getProviderList() {

			$endpoint = "GetProviderList.aspx";

			$url = $this->build_url($endpoint, array());

			return $this->send_request($url);

		}

		

		public function getGameList($provider_code) {

			$endpoint = "GetGameList.aspx";

			$params = array('provider_code' => $provider_code);

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function launchGame($username, $gameid) {

			$endpoint = "OpenGame.aspx";

			$params = array('username' => $username, 'gameid' => $gameid);

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function withdraw($username, $amount) {

			$endpoint = "MakeTransaction.ashx";

			$params = array('username' => $username, 'amount' => $amount, 'type' => 'withdraw');

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function deposit($username, $amount) {

			$endpoint = "MakeTransaction.ashx";

			$params = array('username' => $username, 'amount' => $amount, 'type' => 'deposit');

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function getHistoryBettingMember() {

			$endpoint = "GetHistoryArchive.aspx";

			$url = $this->build_url($endpoint, array());

			return $this->send_request($url);

		}

		

		public function markHistoryBettingMember($trx_id) {

			$endpoint = "MarkHistoryArchive.aspx";

			$params = array('trx_id' => $trx_id);

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		

		public function launchDemoGame($username, $gameid) {

			$endpoint = "OpenDGame.aspx";

			$params = array('username' => $username, 'gameid' => $gameid);

			$url = $this->build_url($endpoint, $params);

			return $this->send_request($url);

		}

		}

	



$SGX = new ApimaxAPI($agen_code, $sign, $base_url);

?>