<?php
session_start();

// ID pengguna yang sedang login
$id_login = $_SESSION['id'];

// Koneksi ke database
include '../function/connect.php';

// Query untuk mendapatkan transaksi terakhir berdasarkan ID pengguna
$query = "SELECT * FROM tb_transaksi WHERE id_user = '$id_pengguna' ORDER BY tanggal DESC LIMIT 1";
$result = mysqli_query($koneksi, $query);

// Cek apakah ada hasil
if ($result && mysqli_num_rows($result) > 0) {
    // Mengambil data transaksi terakhir
    $transaksi = mysqli_fetch_assoc($result);
    $waktu_transaksi = $transaksi['tanggal']; // Tanggal transaksi
    $trx_no = $transaksi['transaksi']; // Nomor transaksi
    $jumlah = $transaksi['total']; // Total deposit
    $status = $transaksi['status']; // Status transaksi
} else {
    // Jika tidak ada data transaksi
    $waktu_transaksi = "Tidak ada data";
    $trx_no = "Tidak ada data";
    $jumlah = "Tidak ada data";
    $status = "Tidak ada data";
}
?>

<!-- Bagian HTML Modal -->
<div class="modal fade" id="customModal" tabindex="-1" role="dialog" aria-labelledby="popup_modal_title" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span>
        </button>
        <h4 class="modal-title" id="popup_modal_title">Transaksi Terakhir</h4>
      </div>
      <div class="modal-body" id="popup_modal_body">
        <div class="modal-standard-header">Transaksi Terakhir</div>

        <div class="pending-transaction-details-container">
          <div class="pending-transaction-details-item">
            <div>
              <span>
                <img class="transaction-icon" loading="lazy" src="//dsuown9evwz4y.cloudfront.net/Images/icons/pending-transaction/deposit.svg?v=20240920">
                <strong>Deposit</strong>
              </span>
              <span data-transaction-status="PEN">
                <img loading="lazy" src="//dsuown9evwz4y.cloudfront.net/Images/icons/pending-transaction/time.svg?v=20240920">
                <strong><?php echo ($status == 'PEN') ? 'Menunggu' : 'Selesai'; ?></strong>
              </span>
            </div>
            <hr>
            <div class="text-left">
              <span><strong>Waktu Transaksi</strong></span>
              <span class="pending-transaction-details-item-value"><?php echo $waktu_transaksi; ?></span>
            </div>
            <div class="text-left">
              <span><strong>Nomor Transaksi</strong></span>
              <span class="pending-transaction-details-item-value"><?php echo $trx_no; ?></span>
            </div>
            <div class="text-left">
              <span><strong>Jumlah</strong></span>
              <span class="pending-transaction-details-item-value">IDR <?php echo number_format($jumlah, 0, ',', '.'); ?></span>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" data-dismiss="modal" id="popup_modal_dismiss_button">OK</button>
      </div>
    </div>
  </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function() {
    const urlParams = new URLSearchParams(window.location.search);
    const pesan = urlParams.get('pesan');

    if (pesan === '30') {
        // Trigger modal popup
$('#customModal').modal('show');
    }
});

</script>
        <style>
        .modal-standard-header {
    text-align: center;
    padding-bottom: 16px;
    position: relative;
    font-size: 14px;
    font-weight: 500;
    line-height: 1;
    margin-top: -20px;
    color: #fff
}
            .modal-body .pending-transaction-summary-container,.pending-transactions-container .pending-transactions-item .pending-transaction-remarks-container,.claim-info-modal .alert-container {
    padding: 16px;
    border: 2px dashed #f41168;
    color: #fff;
    background-color: #25142c;
    border-radius: 8px;
    font-size: 12px
}

.modal-body .pending-transaction-summary-container .pending-transaction-chance-container {
    display: flex;
    width: 100%
}

.modal-body .pending-transaction-summary-container .pending-transaction-chance-container>* {
    flex-basis: 50%
}

.modal-body .pending-transaction-summary-container .pending-transaction-summary-content,.claim-info-modal .alert-container {
    display: flex;
    justify-content: flex-start;
    gap: 15px;
    align-items: center;
    padding-bottom: 10px
}

.modal-body .pending-transaction-summary-container .pending-transaction-summary-content .icon {
    width: 60px
}

.modal-body .pending-transaction-summary-container .pending-transaction-summary-content .pending-transaction-summary {
    display: flex;
    gap: 5px;
    flex-direction: column;
    align-items: flex-start;
    align-content: space-between;
    text-align: left
}

.modal-body .pending-transaction-summary-container .pending-transaction-summary-content .pending-transaction-summary a {
    color: #4b7af2;
    text-decoration: underline
}

.modal-body .pending-transaction-summary-container .pending-transaction-summary-footer {
    border-top: 1px solid #ffffff14;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    gap: 8px
}

.modal-body .pending-transaction-summary-container .pending-transaction-summary-footer a {
    color: #fff;
    padding: 8px 12px;
    border-radius: 5px;
    background-color: #c9176b
}

.modal-body .pending-transaction-details-container {
    color: #fff;
    margin-top: 16px;
    max-height: 45vh;
    border-radius: 5px;
    overflow-y: auto;
    background-color: #101322;
    padding: 12px 16px;
    border: 1px solid #222843;
    font-size: 12px;
    display: flex;
    flex-direction: column;
    gap: 10px
}

.modal-body .pending-transaction-details-container::-webkit-scrollbar {
    width: 7px;
    height: 7px
}

.modal-body .pending-transaction-details-container::-webkit-scrollbar-track {
    background: transparent
}

.modal-body .pending-transaction-details-container::-webkit-scrollbar-thumb {
    background: #4d4f59;
    border-radius: 5px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item {
    padding: 12px;
    background-color: #181d33;
    border: 1px solid #181d33;
    display: flex;
    flex-direction: column;
    gap: 8px;
    font-size: 10px;
    border-radius: 5px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item strong {
    font-weight: 700
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .transaction-icon {
    height: 20px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item hr {
    border-color: #34314e;
    margin-top: 0;
    margin-bottom: 0;
    width: 100%
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div:first-child {
    font-size: 12px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div:first-child span {
    display: flex;
    gap: 4px;
    align-items: center
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div:first-child span:first-child strong {
    text-transform: uppercase
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="PEN"],.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="PEN2"],.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="PRO"],.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="PRO1"],.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="MEW"],.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="APP1"] {
    color: #ff9806
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="REJ"],.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="FAIL"] {
    color: #f44336
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div span[data-transaction-status="APP"] {
    color: #00bd34
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div {
    display: flex;
    justify-content: space-between;
    gap: 4px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div>div {
    display: flex;
    flex-direction: column;
    gap: 4px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item>div>div .pending-transaction-details-item-value {
    font-size: 12px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-remarks {
    font-weight: 700;
    text-align: left;
    display: block
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-remarks ul {
    padding-left: 20px;
    margin-top: 0;
    color: #0094d3
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-section-remarks-title {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 8px;
    font-weight: 700
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-section-bonus-title {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 8px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-participated-bonus .pending-transaction-details-item-bonus-title {
    max-width: 85%;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-participated-bonus .pending-transaction-details-item-bonus-amount {
    flex-grow: 1;
    text-align: right;
    white-space: nowrap
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-participated-bonus[data-bonus-status] {
    background: #9c000099;
    color: #fff;
    padding: 5px 15px;
    border-radius: 20px
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-participated-bonus[data-bonus-status="true"] {
    background: #009c1099
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-participated-bonus[data-bonus-status="pending"] {
    background: #ffffff0f;
    color: #fff;
    border: 1px dashed #ffffff99
}

.modal-body .pending-transaction-details-container .pending-transaction-details-item .pending-transaction-details-item-participated-bonus[data-bonus-status="pending-free-spin"] {
    background: #ffa200
}
        </style>