<?php
session_start(); // Memulai sesi

// Mengecek apakah pengguna sudah login
if (!isset($_SESSION['id'])) {
    // Jika belum login, alihkan ke halaman login
    header("Location: index.php?page=masuk"); // Ganti 'login.php' dengan nama file halaman login Anda
    exit();
}

// Jika sudah login, ambil ID pengguna
$id_login = $_SESSION['id'];
// Anda bisa menggunakan $id_login untuk mengambil data pengguna dari database jika diperlukan
?>
<div class=tab-menu-background-container>

    <div class=tab-menu-container data-style=vertical>

        <a href="?page=profile" data-active=false>

            <i data-icon=profile style="--image-src:url(//d1bnhxh1olb98c.cloudfront.net/Images/nexus-alpha/red/mobile/tabs/profile.svg?v=20240219);--active-image-src:url(//d1bnhxh1olb98c.cloudfront.net/Images/nexus-alpha/red/mobile/tabs/profile-active.svg?v=20240219)"></i>

            Akun Saya 

        </a>

        <a href="?page=ubah_password" data-active=true>

            <i data-icon=password style="--image-src:url(//d1bnhxh1olb98c.cloudfront.net/Images/nexus-alpha/red/mobile/tabs/password.svg?v=20240219);--active-image-src:url(//d1bnhxh1olb98c.cloudfront.net/Images/nexus-alpha/red/mobile/tabs/password-active.svg?v=20240219)"></i>

            Ubah Kata Sandi 

        </a>

    </div>

</div>

<div class=standard-form-container>

    <div class=container>

        <div class=row>

            <div class=col-sm-12>

                <div class=standard-form-title>UBAH KATA SANDI</div>

                <div class=standard-form-note>

                    <span>Catatan:</span>

                    <br>

                    *Password harus terdiri dari 8-20 karakter.<br>

                    *Password harus mengandung huruf dan angka. <br>*Password tidak boleh mengandung username.

                </div>

                <form action="?page=aksi_ubah_password" method=post>

                    <input type="hidden" name="id" value="<?php echo $punya_user['id'] ?>">

                    <div class=form-group>

                        <label for=OldPassword>Kata Sandi Saat Ini</label>

                        <input maxlength=20 class=form-control data-val=true data-val-required="The OldPassword field is required." id=OldPassword name=password_lama placeholder="Kata Sandi Saat Ini" type=password>

                        <span class=standard-required-message>Kata sandi harus diisi.</span>

                    </div>

                    <div class="form-group standard-password-field">

                        <label for=NewPassword>Kata Sandi Baru</label>

                        <input maxlength=20 class=form-control data-val=true data-val-regex="The field NewPassword must match the regular expression '^(?=.{8,20}$)(?=.*?[a-z])(?=.*?[0-9]).*$'." data-val-regex-pattern="^(?=.{8,20}$)(?=.*?[a-z])(?=.*?[0-9]).*$" data-val-required="The NewPassword field is required." id=new_password_input name=password_baru placeholder="Kata Sandi Baru" type=password>

                        <span class=standard-required-message>Kata Sandi harus terdiri dari 8-20 karakter, harus mengandung huruf dan angka.</span>

                        <i class="glyphicon glyphicon-eye-open" id=new_password_input_trigger></i>

                    </div>

                    <div class="form-group standard-password-field">

                        <label for=ConfirmPassword>Ulangi Kata Sandi</label>

                        <input maxlength=20 class=form-control data-val=true data-val-equalto="'ConfirmPassword' and 'NewPassword' do not match." data-val-equalto-other=*.NewPassword data-val-required="The ConfirmPassword field is required." id=confirm_password_input name=konfirmasi_password_baru placeholder="Ulangi Kata Sandi" type=password>

                        <span class=standard-required-message>* Kata sandi tidak cocok.</span>

                        <i class="glyphicon glyphicon-eye-open" id=confirm_password_input_trigger></i>

                    </div>

                    <div class=form-group>

                        <label for=VerificationCode>Kode Verifikasi</label>

                        <div data-section=input class=captcha-input>

                            <input class="form-control" data-val="true" id="VerificationCode" name="captcha" placeholder="Validasi" type="text"> 

                            <span class="standard-required-message">Silakan masukkan captcha!</span>

                            <div class="captcha-container">

                                <?php $captchaNumber = rand(0, 999999); ?>

                                <div style="font-size: 24px; background-color: white; color: black; padding: 4px;"><?php echo $captchaNumber; ?></div>

                                <input type="hidden" name="captcha_asli" value="<?php echo $captchaNumber; ?>">

                            </div>

                        </div>

                    </div>

                    <div class=standard-button-group>

                        <input type=submit name="submit" class=standard-secondary-button value="UBAH KATA SANDI">

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>