<?php

// Membuat array data permintaan untuk API

$postArray = [

    'command' => 'provider_list', 

    'agent_code' => 'jarwo', 

    'signature' => '6f8f48dc3f01f7650b8a5454918426de'

];



// Mengonversi array ke JSON

$jsonData = json_encode($postArray);



// Mengatur header untuk request

$headerArray = ['Content-Type: application/json'];



// Inisialisasi CURL

$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, 'https://sgx.center/api/');

curl_setopt($ch, CURLOPT_POST, 1);

curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Agar respons disimpan sebagai string

curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // Batas waktu koneksi



// Eksekusi CURL dan ambil respons

$response = curl_exec($ch);



// Memeriksa jika ada error pada CURL

if (curl_errno($ch)) {

    echo 'Curl error: ' . curl_error($ch);

} else {

    // Menutup koneksi CURL

    curl_close($ch);



    // Mendekode respons JSON

    $data = json_decode($response, true);



    // Memeriksa status respons

    if ($data['status'] == 200 && !empty($data['providers'])) {

        echo "========================\n";

        echo "   PROVIDER TYPES   \n";

        echo "========================\n\n";



        // Tampilkan hanya provider type

        foreach ($data['providers'] as $provider) {

            echo "Provider Type: " . $provider['provider_type'] . "\n";

            echo "---------------------------------\n";

        }



    } else {

        // Jika respons gagal

        echo "Error: " . $data['message'] . "\n";

    }

}

?>

