<?php
// debug-quick.php — TEMPORARY: paste ke file yang tampil di browser
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try {
    require 'main/API/integration.php';
    require 'function/connect.php';

    // cek apakah $SGX tersedia
    if (!isset($SGX)) {
        throw new Exception('$SGX tidak didefinisikan. Periksa main/API/integration.php');
    }

    $act = $SGX->create('askakdpoxxa6');

    // lihat konten kembalian
    var_dump($act);

    $res = json_decode($act, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo 'JSON decode error: ' . json_last_error_msg();
    } else {
        var_dump($res);
    }

} catch (Throwable $e) {
    http_response_code(500);
    echo "EXCEPTION: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine();
    // tulis ke file log sementara
    file_put_contents('/tmp/php-debug.log', date('c') . " | " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine() . PHP_EOL, FILE_APPEND);
}
exit;