<?php include 'function/connect.php'; ?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>Tabel Provider</title>
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
		<style>
			body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
			}
			h2 {
            text-align: center;
            color: #333;
			}
			table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            background-color: #fff;
            border-radius: 10px;
            overflow: hidden;
			}
			th, td {
            padding: 15px;
            text-align: left;
			}
			th {
            background-color: #007BFF;
            color: white;
            font-weight: bold;
			}
			td {
            color: #555;
			}
			tr:nth-child(even) {
            background-color: #f9f9f9;
			}
			tr:hover {
            background-color: #f1f1f1;
			}
			.update-btn {
            background-color: #28a745; /* Hijau */
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            font-size: 14px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
            display: inline-flex;
            align-items: center;
			}
			.update-btn:hover {
            background-color: #218838;
			}
			.update-btn i {
            margin-right: 5px;
			}
			.update-btn:active {
            background-color: #1e7e34;
			}
		</style>
	</head>
	<body>
		
		<h2>Tabel Provider</h2>
		
		<table>
			<thead>
				<tr>
					<th>No</th>
					<th>Nama Provider</th>
					<th>Kategori</th>
					<th>Provider API</th>
					<th>Action</th>
				</tr>
			</thead>
			<tbody>
				<?php
					// Query untuk mengambil data penyedia permainan dari database
					$no = 1;
					$query = mysqli_query($conn, "SELECT * FROM tb_provider");
					while ($provider = mysqli_fetch_assoc($query)) {
						$provider_name = $provider['providername'];
						$provider_type = $provider['type'];
						$provider_api = $provider['providerapi'];
					?>
					<tr>
						<td><?= $no++; ?></td>
						<td><?= $provider_name; ?></td>
						<td><?= $provider_type; ?></td>
						<td><?= $provider_api; ?></td>
						<td><button class="update-btn" onclick="updateGame('<?= $provider['cuid']; ?>')"><i class="fas fa-edit"></i> Update Game</button></td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
<script>
        // Fungsi JavaScript untuk update game
        function updateGame(providerName) {
            // Logika untuk update game
            alert('Proses update game untuk ' + providerName + ' telah dimulai.');

            // Menggunakan fetch untuk mengirim POST request
            fetch('update_game.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ cuid: providerName }), // Menggunakan body bukan data
            })
            .then(response => response.json()) // Menambahkan konversi response ke JSON
            .then(data => {
                console.log('Success:', data);
                alert(data.message); // Menampilkan pesan dari response
            })
            .catch(error => console.error('Error:', error)); // Menangani error
        }
    </script>
	</body>
</html>
